% Read digital filter coefficients from a .coe file.
hd = coeread('E:\testRead.coe');

% Set a filter property with 'set()'
set(hd, 'arithmetic', 'fixed'); % 'single'-precision or 'fixed'

% Read filter properties with 'get(hd)'
get(hd);

% Write a digital filter into a .coe file.
coewrite(hd, 10, 'filter/testWrite.coe');


%%% Other notes
% To generate digital filters, use the 'dfilt' function.
% You must specify the type of filter using the dot operator ie.
% hd=dfilt.fir1(...)


%% Example: Make cascade of discrete filters.

% Generate transfer function for a butterworth filter
[b1,a1]=butter(8,0.6);          % Lowpass
[b2,a2]=butter(8,0.4,'high');   % Highpass
% Generate discrete-time filter using transfer function.
H1=dfilt.df2t(b1,a1);
H2=dfilt.df2t(b2,a2);
% Cascade (serially connect) the two filters.
Hcas=dfilt.cascade(H1,H2)       % Bandpass-passband .4-.6
% Display final cascaded filter properties (magnitude-phase response,
% zero-pole plot)
fvtool(Hcas)

get(Hcas.Stage(1)) % To see properties of a particular filter in cascade.